/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest.area;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.quests.QuestSystem;
import dev.toma.gunsrpg.common.quests.adapters.MobSpawnerAdapter;
import dev.toma.gunsrpg.common.quests.quest.area.IMobSpawner;
import dev.toma.gunsrpg.common.quests.quest.area.MobSpawner;
import dev.toma.gunsrpg.common.quests.quest.area.QuestArea;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import dev.toma.gunsrpg.util.math.WeightedRandom;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public final class QuestAreaScheme {
    private final int size;
    private final int distance;
    private final int spawnInterval;
    private final WeightedRandom<IMobSpawner> spawners;

    public QuestAreaScheme(int size, int distance, int spawnInterval, IMobSpawner[] spawners) {
        this.size = size;
        this.distance = distance;
        this.spawnInterval = spawnInterval;
        this.spawners = new WeightedRandom<IMobSpawner>(IMobSpawner::getWeight, spawners);
    }

    public QuestArea getArea(World world, int positionX, int positionZ) {
        GunsRPG.log.debug(QuestSystem.MARKER, "Generating new quest area");
        int minDist = this.distance;
        int maxDist = this.distance * 3;
        Random random = world.field_73012_v;
        int x = this.getRandomDistance(minDist, maxDist, random);
        int z = this.getRandomDistance(minDist, maxDist, random);
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        mutable.func_223471_o(positionX + x);
        mutable.func_223472_q(positionZ + z);
        Biome biome = world.func_226691_t_((BlockPos)mutable);
        int attemptIndex = 0;
        while (biome.func_201856_r() == Biome.Category.RIVER || biome.func_201856_r() == Biome.Category.OCEAN) {
            x = this.getRandomDistance(minDist, maxDist, random);
            z = this.getRandomDistance(minDist, maxDist, random);
            mutable.func_223471_o(positionX + x);
            mutable.func_223472_q(positionZ + z);
            biome = world.func_226691_t_((BlockPos)mutable);
            if (++attemptIndex != 100) continue;
        }
        GunsRPG.log.debug(QuestSystem.MARKER, "Generated area at [{},{}] after {} attempts", (Object)mutable.func_177958_n(), (Object)mutable.func_177952_p(), (Object)(attemptIndex + 1));
        return new QuestArea(this, mutable.func_185334_h());
    }

    public int getSize() {
        return this.size;
    }

    public int getDistance() {
        return this.distance;
    }

    public int getSpawnInterval() {
        return this.spawnInterval;
    }

    public IMobSpawner getSpawner() {
        return this.spawners.getRandom();
    }

    public String toString() {
        return String.format("Size: %d, MinDistance: %d, SpawnerCount: %d", this.size, this.distance, this.spawners.getValueCount());
    }

    public CompoundNBT toNbt() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("size", this.size);
        nbt.func_74768_a("distance", this.distance);
        nbt.func_74768_a("spawnInterval", this.spawnInterval);
        ListNBT spawners = new ListNBT();
        Arrays.stream(this.spawners.getValues()).map(IMobSpawner::toNbt).forEach(arg_0 -> spawners.add(arg_0));
        nbt.func_218657_a("spawners", (INBT)spawners);
        return nbt;
    }

    private int getRandomDistance(int minDist, int maxDist, Random random) {
        return random.nextBoolean() ? minDist + random.nextInt(maxDist) : -minDist - random.nextInt(maxDist);
    }

    public static QuestAreaScheme fromNbt(CompoundNBT nbt) {
        int size = nbt.func_74762_e("size");
        int distance = nbt.func_74762_e("distance");
        int spawnInterval = nbt.func_74762_e("spawnInterval");
        ListNBT spawnersNbt = nbt.func_150295_c("spawners", 10);
        IMobSpawner[] spawners = (IMobSpawner[])spawnersNbt.stream().map(inbt -> MobSpawner.fromNbt((CompoundNBT)inbt)).toArray(IMobSpawner[]::new);
        return new QuestAreaScheme(size, distance, spawnInterval, spawners);
    }

    public static QuestAreaScheme fromJson(JsonObject object) throws JsonParseException {
        IMobSpawner[] spawners;
        int size = JSONUtils.func_151203_m((JsonObject)object, (String)"size");
        int distance = JSONUtils.func_151203_m((JsonObject)object, (String)"distance");
        int spawnInterval = JSONUtils.func_151208_a((JsonObject)object, (String)"spawnInterval", (int)20);
        if (object.has("spawners")) {
            JsonArray array = JSONUtils.func_151214_t((JsonObject)object, (String)"spawners");
            MobSpawnerAdapter adapter = new MobSpawnerAdapter();
            spawners = JsonHelper.deserializeInto(array, IMobSpawner[]::new, adapter::deserialize);
        } else {
            spawners = new IMobSpawner[]{};
        }
        return new QuestAreaScheme(size, distance, spawnInterval, spawners);
    }
}

